<?php
// Start the session
session_start();

// Include database connection file
include('includes/dbconn.php');

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form data
    $company_id = $_SESSION['company_id']; // Assuming session contains company_id
    $account_name = $_POST['account_name'];
    $account_type = $_POST['account_type'];

    // Prepare an insert statement
    $sql = "INSERT INTO chart_of_accounts (company_id, account_name, account_type) VALUES (?, ?, ?)";
    
    if ($stmt = $conn->prepare($sql)) {
        // Bind variables to the prepared statement as parameters
        $stmt->bind_param("iss", $company_id, $account_name, $account_type);
        
        // Attempt to execute the prepared statement
        if ($stmt->execute()) {
            // Close statement
            $stmt->close();
            // Close connection
            $conn->close();
            
            // Redirect to create_accounts.php
            header("Location: create_accounts.php");
            exit;
        } else {
            echo "Error: Could not execute the query: " . $stmt->error;
        }
    } else {
        echo "Error: Could not prepare the query: " . $conn->error;
    }

    // Close connection
    $conn->close();
}
?>
